/**
  ******************************************************************************
  * @file    py32f032_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
  * @brief Initialize I2C MSP
  */
void HAL_I2C_MspInit(I2C_HandleTypeDef *hi2c)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  
  __HAL_RCC_GPIOA_CLK_ENABLE();                       /* Enable GPIOA clock */
  __HAL_RCC_SYSCFG_CLK_ENABLE();                      /* Enable SYSCFG clock */
  __HAL_RCC_I2C1_CLK_ENABLE();                        /* Enable I2C1 clock */

  /**I2C GPIO Configuration
  PA8  -------> I2C1_SCL
  PA7  -------> I2C1_SDA
  */
  GPIO_InitStruct.Pin       = GPIO_PIN_7 | GPIO_PIN_8;
  GPIO_InitStruct.Mode      = GPIO_MODE_AF_OD;               /* Open-drain mode */
  GPIO_InitStruct.Pull      = GPIO_PULLUP;                   /* Pull-up */
  GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_VERY_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_I2C1;                /* Alternate as I2C */
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);                    /* Initialize GPIO */
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
